% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notification.R
\name{notification}
\alias{notification}
\alias{show_notification}
\alias{clear_notifications}
\title{The 'Bootstrap' notification}
\usage{
show_notification(
  message,
  title = "Notification!",
  subtitle = "",
  type = c("default", "info", "warning", "success", "danger", "white", "dark"),
  close = TRUE,
  position = c("topRight", "topLeft", "bottomRight", "bottomLeft"),
  autohide = TRUE,
  fixed = TRUE,
  delay = 5000,
  icon = NULL,
  collapse = "",
  session = shiny::getDefaultReactiveDomain(),
  class = NULL,
  ...
)

clear_notifications(class = NULL, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{message}{notification body content, can be 'HTML' tags}

\item{title, subtitle}{title and subtitle of the notification}

\item{type}{type of the notification; can be \code{"default"},
\code{"info"}, \code{"warning"}, \code{"success"}, \code{"danger"},
\code{"white"}, \code{"dark"}}

\item{close}{whether to allow users to close the notification}

\item{position}{where the notification should be; choices are
\code{"topRight"}, \code{"topLeft"}, \code{"bottomRight"},
\code{"bottomLeft"}}

\item{autohide}{whether to automatically hide the notification}

\item{fixed}{whether the position should be fixed}

\item{delay}{integer in millisecond to hide the notification if
\code{autohide=TRUE}}

\item{icon}{the icon of the title}

\item{collapse}{if \code{message} is a character vector, the collapse string}

\item{session}{shiny session domain}

\item{class}{the extra class of the notification, can be used for style
purposes, or by \code{clear_notifications} to close specific notification
types.}

\item{...}{other options; see
\url{https://adminlte.io/docs/3.1//javascript/toasts.html#options}}
}
\value{
Both functions should be used in shiny reactive contexts. The
messages will be sent to shiny 'JavaScript' interface and nothing will be
returned.
}
\description{
The 'Bootstrap' notification
}
\examples{
\dontrun{

# the examples must run in shiny reactive context

show_notification(
  message = "This validation process has finished. You are welcome to proceed.",
  autohide = FALSE,
  title = "Success!",
  subtitle = "type='success'",
  type = "success"
)

show_notification(
  message = "This notification has title and subtitle",
  autohide = FALSE,
  title = "Hi there!",
  subtitle = "Welcome!",
  icon = "kiwi-bird",
  class = "notification-auto"
)

# only clear notifications with class "notification-auto"
clear_notifications("notification-auto")

}
}
