% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widgets.R
\name{add-remove-html-class}
\alias{add-remove-html-class}
\alias{add_class}
\alias{remove_class}
\title{Add or remove 'HTML' class from 'RAVE' application}
\usage{
add_class(selector, class, session = shiny::getDefaultReactiveDomain())

remove_class(selector, class, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{selector}{'CSS' selector}

\item{class}{class to add or to remove from selected elements}

\item{session}{shiny session}
}
\value{
No value is returned
}
\description{
Only works in template framework provided by 'shidashi' package,
see \code{\link[shidashi]{use_template}}
}
\examples{

server <- function(input, output, session){

  # Add class `hidden` to element with ID `elemid`
  add_class("#elemid", "hidden")

  # Remove class `hidden` from element with class `shiny-input-optional`
  remove_class(".shiny-input-optional", "hidden")
}

}
