% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{Tabs}
\alias{Tabs}
\alias{Tab}
\alias{TabsExpander}
\title{Tabs}
\usage{
Tabs(...)

Tab(...)

TabsExpander(...)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/tabs}
}
\examples{
library(shiny.blueprint)
library(shiny)

ui <- function(id) {
  ns <- NS(id)
  reactOutput(ns("tabs"))
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    ns <- session$ns

    currentTab <- reactiveVal("react")
    observeEvent(input$selectTab, currentTab(input$selectTab))
    output$tabs <- renderReact(
      Tabs(
        selectedTabId = currentTab(),
        onChange = setInput(ns("selectTab")),
        Tab(id = "angular", title = "Angular", panel = "Angular"),
        Tab(id = "ember", title = "Ember", panel = "Ember"),
        Tab(id = "react", title = "React", panel = "React"),
        TabsExpander(),
        tags$input(class = "bp4-input", type = "text", placeholder = "Search...")
      )
    )
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
