% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Dialog}
\alias{Dialog}
\alias{DialogFooter}
\title{Dialog}
\usage{
Dialog(...)

DialogFooter(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A dialog box (\code{Dialog}) is a temporary pop-up that takes focus from the page or app and requires people to interact with it. It’s primarily used for confirming actions, such as deleting a file, or asking people to make a choice.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Dialog}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ className }} {\code{string} \cr Optional override class name}
\item {\bold{ closeButtonAriaLabel }} {\code{string} \cr Label to be passed to to aria-label of close button}
\item {\bold{ componentRef }} {\verb{IRefObject<IDialogContent>} \cr Optional callback to access the IDialogContent interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ draggableHeaderClassName }} {\code{string} \cr The classname for when the header is draggable}
\item {\bold{ isMultiline }} {\code{boolean} \cr Is inside a multiline wrapper}
\item {\bold{ onDismiss }} {\verb{(ev?: React.MouseEvent<HTMLButtonElement>) => any} \cr Callback for when the Dialog is dismissed from the close button or light dismiss, before the animation completes.}
\item {\bold{ responsiveMode }} {\code{ResponsiveMode} \cr Responsive mode passed in from decorator.}
\item {\bold{ showCloseButton }} {\code{boolean} \cr Show an 'x' close button in the upper-right corner}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IDialogContentStyleProps, IDialogContentStyles>} \cr Call to provide customized styling that will layer on top of the variant rules}
\item {\bold{ subText }} {\code{string} \cr The subtext to display in the dialog}
\item {\bold{ subTextId }} {\code{string} \cr The Id for subText container}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
\item {\bold{ title }} {\code{string | JSX.Element} \cr The title text to display at the top of the dialog.}
\item {\bold{ titleId }} {\code{string} \cr The Id for title container}
\item {\bold{ titleProps }} {\verb{React.HTMLAttributes<HTMLDivElement>} \cr The props for title container.}
\item {\bold{ topButtonsProps }} {\code{IButtonProps[]} \cr Other top buttons that will show up next to the close button}
\item {\bold{ type }} {\code{DialogType} \cr The type of Dialog to display.}
\item {\bold{ className }} {\code{string} \cr Optional override class name}
\item {\bold{ componentRef }} {\verb{IRefObject<IDialogFooter>} \cr Gets the component ref.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IDialogFooterStyleProps, IDialogFooterStyles>} \cr Call to provide customized styling that will layer on top of the variant rules}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
\item {\bold{ ariaDescribedById }} {\code{string} \cr Optional id for aria-DescribedBy}
\item {\bold{ ariaLabelledById }} {\code{string} \cr Optional id for aria-LabelledBy}
\item {\bold{ className }} {\code{string} \cr Optional class name to be added to the root class}
\item {\bold{ componentRef }} {\verb{IRefObject<IDialog>} \cr Optional callback to access the IDialog interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ containerClassName }} {\code{string} \cr Optional override for container class}
\item {\bold{ contentClassName }} {\code{string} \cr Optional override content class}
\item {\bold{ dialogContentProps }} {\code{IDialogContentProps} \cr Props to be passed through to Dialog Content}
\item {\bold{ hidden }} {\code{boolean} \cr Whether the dialog is hidden.}
\item {\bold{ isBlocking }} {\code{boolean} \cr Whether the dialog can be light dismissed by clicking outside the dialog (on the overlay).}
\item {\bold{ isDarkOverlay }} {\code{boolean} \cr Whether the overlay is dark themed.}
\item {\bold{ isOpen }} {\code{boolean} \cr Whether the dialog is displayed. Deprecated, use \code{hidden} instead.}
\item {\bold{ maxWidth }} {\code{ICSSRule | ICSSPixelUnitRule} \cr Sets the maximum width for the dialog. It limits the width property to be larger than the value specified in max-width.}
\item {\bold{ minWidth }} {\code{ICSSRule | ICSSPixelUnitRule} \cr Sets the minimum width of the dialog. It limits the width property to be not smaller than the value specified in min-width.}
\item {\bold{ modalProps }} {\code{IModalProps} \cr Props to be passed through to Modal}
\item {\bold{ onDismiss }} {\verb{(ev?: React.MouseEvent<HTMLButtonElement>) => any} \cr A callback function for when the Dialog is dismissed from the close button or light dismiss. Can also be specified separately in content and modal.}
\item {\bold{ onDismissed }} {\verb{() => any} \cr A callback function which is called after the Dialog is dismissed and the animation is complete.}
\item {\bold{ onLayerDidMount }} {\verb{() => void} \cr A callback function for when the Dialog content is mounted on the overlay layer}
\item {\bold{ onLayerMounted }} {\verb{() => void} \cr Deprecated at 0.81.2, use \code{onLayerDidMount} instead.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IDialogStyleProps, IDialogStyles>} \cr Call to provide customized styling that will layer on top of the variant rules}
\item {\bold{ subText }} {\code{string} \cr The subtext to display in the dialog.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
\item {\bold{ title }} {\code{string | JSX.Element} \cr The title text to display at the top of the dialog.}
\item {\bold{ topButtonsProps }} {\code{IButtonProps[]} \cr Other top buttons that will show up next to the close button}
\item {\bold{ type }} {\code{DialogType} \cr The type of Dialog to display.}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Don't use more than three buttons.
\item Dialog boxes consist of a header, body, and footer.
\item Validate that people’s entries are acceptable before closing the dialog box. Show an inline validation error near the field they must correct.
\item Blocking dialogs should be used very sparingly, only when it is critical that people make a choice or provide information before they can proceed. Blocking dialogs are generally used for irreversible or potentially destructive tasks. They’re typically paired with an overlay without a light dismiss.
}
\subsection{Header}{
\itemize{
\item Locks to the top of the dialog.
\item May include an icon to the left of the title.
\item Includes a Close button in the top-right corner.
}
}

\subsection{Footer}{
\itemize{
\item Lock buttons to the bottom of the dialog.
\item Includes one primary button. A secondary button is optional.
}
}

\subsection{Width}{
\itemize{
\item Maximum is 340 pixels.
\item Minimum is 288 pixels.
}
}

\subsection{Height}{
\itemize{
\item Maximum is 340 pixels.
\item Minimum is 172 pixels.
}
}

}

\subsection{Content}{
\subsection{Title}{
\itemize{
\item Keep the title as concise as possible.
\item Don’t use periods at the end of titles.
\item This mandatory content should explain the main information in a clear, concise, and specific statement or question. For example, “Delete this file?” instead of “Are you sure?”
\item The title shouldn’t be a description of the body content. For example, don’t use “Error” as a title. Instead, use an informative statement like “Your session ended.”
\item Use sentence-style capitalization—only capitalize the first word. For more info, see \href{https://docs.microsoft.com/style-guide/capitalization}{Capitalization} in the Microsoft Writing Style Guide.
}
}

\subsection{Body copy (Optional)}{
\itemize{
\item Don't restate the title in the body.
\item Use ending punctuation on sentences.
\item Use actionable language, with the most important information at the beginning.
\item Use the optional body content area for additional info or instructions, if needed. Only include information needed to help people make a decision.
}
}

\subsection{Button labels}{
\itemize{
\item Write button labels that are specific responses to the main information in the title. The title “Delete this file?” could have buttons labeled “Delete” and “Cancel”.
\item Be concise. Limit labels to one or two words. Usually a single verb is best. Include a noun if there is any room for interpretation about what the verb means. For example, “Delete” or “Delete file”.
}
}

}
}

\examples{
library(shiny.fluent)

if (interactive()) {
  shinyApp(
    ui = div(
      DefaultButton.shinyInput("showDialog", text = "Open dialog"),
      reactOutput("reactDialog")
    ),
    server = function(input, output) {
      isDialogOpen <- reactiveVal(FALSE)
      output$reactDialog <- renderReact({
        dialogContentProps <- list(
          type=0,
          title='Missing Subject',
          closeButtonAriaLabel='Close',
          subText='Do you want to send this message without a subject?'
        )
        Dialog(
          hidden = !isDialogOpen(),
          onDismiss = JS("function() { Shiny.setInputValue('hideDialog', Math.random()); }"),
          dialogContentProps = dialogContentProps,
          modalProps = list(),
          DialogFooter(
            PrimaryButton.shinyInput("dialogSend", text = "Send"),
            DefaultButton.shinyInput("dialogDontSend", text = "Don't send")
          )
        )
      })

      observeEvent(input$showDialog, isDialogOpen(TRUE))
      observeEvent(input$hideDialog, isDialogOpen(FALSE))
      observeEvent(input$dialogSend, isDialogOpen(FALSE))
      observeEvent(input$dialogDontSend, isDialogOpen(FALSE))
    }
  )
}
}
