% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{grid}
\alias{grid}
\title{Use CSS grid template in Shiny UI}
\usage{
grid(
  grid_template,
  container_style = "",
  area_styles = list(),
  display_mode = FALSE,
  ...
)
}
\arguments{
\item{grid_template}{grid template created with grid_template() function}

\item{container_style}{character - string of custom CSS for the main grid container}

\item{area_styles}{list of custom CSS styles for provided area names}

\item{display_mode}{replaces areas HTML content with <area name> text. Used by display_grid() function}

\item{...}{areas HTML content provided by named arguments}
}
\value{
Rendered HTML ready to use by Shiny UI. See \code{htmltools::htmlTemplate()} for more details.
}
\description{
Use CSS grid template in Shiny UI
}
\details{
Grids can be nested.
}
\examples{
myGrid <- grid_template(default = list(
  areas = rbind(
    c("header", "header", "header"),
    c("menu",   "main",   "right1"),
    c("menu",   "main",   "right2")
  ),
  rows_height = c("50px", "auto", "100px"),
  cols_width = c("100px", "2fr", "1fr")
))

subGrid <- grid_template(default = list(
  areas = rbind(
    c("top_left", "top_right"),
    c("bottom_left", "bottom_right")
  ),
  rows_height = c("50\%", "50\%"),
  cols_width = c("50\%", "50\%")
))

if (interactive()){
library(shiny)
library(shiny.semantic)
shinyApp(
  ui = semanticPage(
    grid(myGrid,
         container_style = "border: 1px solid #f00",
         area_styles = list(header = "background: #0099f9",
                            menu = "border-right: 1px solid #0099f9"),
         header = div(shiny::tags$h1("Hello CSS Grid!")),
         menu = checkbox_input("example", "Check me", is_marked = FALSE),
         main = grid(subGrid,
                     top_left = calendar("my_calendar"),
                     top_right = div("hello 1"),
                     bottom_left = div("hello 2"),
                     bottom_right = div("hello 3")
         ),
         right1 = div(
           toggle("toggle", "let's toggle"),
           multiple_checkbox("mycheckbox", "mycheckbox",
                             c("option A","option B","option C"))),
         right2 = div("right 2")
    )
  ),
  server = shinyServer(function(input, output) {})
)
}
}
