% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{update_action_button}
\alias{update_action_button}
\alias{updateActionButton}
\title{Change the label or icon of an action button on the client}
\usage{
update_action_button(session, input_id, label = NULL, icon = NULL)

updateActionButton(session, inputId, label = NULL, icon = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{input_id}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{icon}{The icon to set for the input object. To remove the current icon, use icon=character(0)}

\item{inputId}{the same as \code{input_id}}
}
\description{
Change the label or icon of an action button on the client
}
\examples{

if (interactive()){
library(shiny)
library(shiny.semantic)

ui <- semanticPage(
  actionButton("update", "Update button"),
  br(),
  actionButton("go_button", "Go")
)

server <- function(input, output, session) {
  observe({
    req(input$update)

    # Updates go_button's label and icon
    updateActionButton(session, "go_button",
                       label = "New label",
                       icon = icon("calendar"))

  })
}
shinyApp(ui, server)
}

}
