% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkboxGroupInput}
\alias{checkboxGroupInput}
\title{Checkbox Group Input Control}
\usage{
checkboxGroupInput(inputId, label, choices, selected = NULL, inline = FALSE)
}
\arguments{
\item{inputId}{Input variable to assign the control's value to.}

\item{label}{Display label for the control, or \code{NULL}.}

\item{choices}{List of values to show checkboxes for. If elements of the list
are named then that name rather than the value is displayed to the user.}

\item{selected}{The values that should be initially selected, if any.}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally)}
}
\value{
A list of HTML elements that can be added to a UI definition.
}
\description{
Create a group of checkboxes that can be used to toggle multiple choices
independently. The server will receive the input as a character vector of the
selected values.
}
\examples{
checkboxGroupInput("variable", "Variable:",
                   c("Cylinders" = "cyl",
                     "Transmission" = "am",
                     "Gears" = "gear"))
}
\seealso{
\code{\link{checkboxInput}}, \code{\link{updateCheckboxGroupInput}}

Other input.elements: \code{\link{actionButton}},
  \code{\link{actionLink}}; \code{\link{animationOptions}},
  \code{\link{sliderInput}}; \code{\link{checkboxInput}};
  \code{\link{dateInput}}; \code{\link{dateRangeInput}};
  \code{\link{fileInput}}; \code{\link{numericInput}};
  \code{\link{radioButtons}}; \code{\link{selectInput}},
  \code{\link{selectizeInput}}; \code{\link{submitButton}};
  \code{\link{textInput}}
}

