% Generated by roxygen2 (4.0.2): do not edit by hand
\name{validate}
\alias{need}
\alias{validate}
\title{Validate input values and other conditions}
\usage{
validate(..., errorClass = character(0))

need(expr, message = paste(label, "must be provided"), label)
}
\arguments{
\item{...}{A list of tests. Each test should equal \code{NULL} for success,
\code{FALSE} for silent failure, or a string for failure with an error
message.}

\item{errorClass}{A CSS class to apply. The actual CSS string will have
\code{shiny-output-error-} prepended to this value.}

\item{expr}{An expression to test. The condition will pass if the expression
meets the conditions spelled out in Details.}

\item{message}{A message to convey to the user if the validation condition is
not met. If no message is provided, one will be created using \code{label}.
To fail with no message, use \code{FALSE} for the message.}

\item{label}{A human-readable name for the field that may be missing. This
parameter is not needed if \code{message} is provided, but must be provided
otherwise.}
}
\description{
For an output rendering function (e.g. \code{\link{renderPlot}()}), you may
need to check that certain input values are available and valid before you
can render the output. \code{validate} gives you a convenient mechanism for
doing so.
}
\details{
The \code{validate} function takes any number of (unnamed) arguments, each of
which represents a condition to test. If any of the conditions represent
failure, then a special type of error is signaled which stops execution. If
this error is not handled by application-specific code, it is displayed to
the user by Shiny.

An easy way to provide arguments to \code{validate} is to use the \code{need}
function, which takes an expression and a string; if the expression is
considered a failure, then the string will be used as the error message. The
\code{need} function considers its expression to be a failure if it is any of
the following:

\itemize{
  \item{\code{FALSE}}
  \item{\code{NULL}}
  \item{\code{""}}
  \item{An empty atomic vector}
  \item{An atomic vector that contains only missing values}
  \item{A logical vector that contains all \code{FALSE} or missing values}
  \item{An object of class \code{"try-error"}}
  \item{A value that represents an unclicked \code{\link{actionButton}}}
}

If any of these values happen to be valid, you can explicitly turn them to
logical values. For example, if you allow \code{NA} but not \code{NULL}, you
can use the condition \code{!is.null(input$foo)}, because \code{!is.null(NA)
== TRUE}.

If you need validation logic that differs significantly from \code{need}, you
can create other validation test functions. A passing test should return
\code{NULL}. A failing test should return an error message as a
single-element character vector, or if the failure should happen silently,
\code{FALSE}.

Because validation failure is signaled as an error, you can use
\code{validate} in reactive expressions, and validation failures will
automatically propagate to outputs that use the reactive expression. In
other words, if reactive expression \code{a} needs \code{input$x}, and two
outputs use \code{a} (and thus depend indirectly on \code{input$x}), it's
not necessary for the outputs to validate \code{input$x} explicitly, as long
as \code{a} does validate it.
}
\examples{
# in ui.R
fluidPage(
  checkboxGroupInput('in1', 'Check some letters', choices = head(LETTERS)),
  selectizeInput('in2', 'Select a state', choices = state.name),
  plotOutput('plot')
)

# in server.R
function(input, output) {
  output$plot <- renderPlot({
    validate(
      need(input$in1, 'Check at least one letter!'),
      need(input$in2 == '', 'Please choose a state.')
    )
    plot(1:10, main = paste(c(input$in1, input$in2), collapse = ', '))
  })
}
}

