% Generated by roxygen2 (4.0.2): do not edit by hand
\name{selectInput}
\alias{selectInput}
\alias{selectizeInput}
\title{Create a select list input control}
\usage{
selectInput(inputId, label, choices, selected = NULL, multiple = FALSE,
  selectize = TRUE, width = NULL)

selectizeInput(inputId, ..., options = NULL, width = NULL)
}
\arguments{
\item{inputId}{Input variable to assign the control's value to}

\item{label}{Display label for the control, or \code{NULL}}

\item{choices}{List of values to select from. If elements of the list are
named then that name rather than the value is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if
\code{multiple = TRUE}). If not specified then defaults to the first value
for single-select lists and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{selectize}{Whether to use \pkg{selectize.js} or not.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}

\item{...}{Arguments passed to \code{selectInput()}.}

\item{options}{A list of options. See the documentation of \pkg{selectize.js}
for possible options (character option values inside \code{\link{I}()} will
be treated as literal JavaScript code; see \code{\link{renderDataTable}()}
for details).}
}
\value{
A select list control that can be added to a UI definition.
}
\description{
Create a select list that can be used to choose a single or
multiple items from a list of values.
}
\details{
By default, \code{selectInput()} and \code{selectizeInput()} use the
JavaScript library \pkg{selectize.js} (\url{https://github.com/brianreavis/selectize.js})
to instead of the basic select input element. To use the standard HTML select
input element, use \code{selectInput()} with \code{selectize=FALSE}.
}
\note{
The selectize input created from \code{selectizeInput()} allows
  deletion of the selected option even in a single select input, which will
  return an empty string as its value. This is the default behavior of
  \pkg{selectize.js}. However, the selectize input created from
  \code{selectInput(..., selectize = TRUE)} will ignore the empty string
  value when it is a single choice input and the empty string is not in the
  \code{choices} argument. This is to keep compatibility with
  \code{selectInput(..., selectize = FALSE)}.
}
\examples{
selectInput("variable", "Variable:",
            c("Cylinders" = "cyl",
              "Transmission" = "am",
              "Gears" = "gear"))
}
\seealso{
\code{\link{updateSelectInput}}

Other input.elements: \code{\link{actionButton}},
  \code{\link{actionLink}}; \code{\link{animationOptions}},
  \code{\link{sliderInput}};
  \code{\link{checkboxGroupInput}};
  \code{\link{checkboxInput}}; \code{\link{dateInput}};
  \code{\link{dateRangeInput}}; \code{\link{fileInput}};
  \code{\link{numericInput}}; \code{\link{radioButtons}};
  \code{\link{submitButton}}; \code{\link{textInput}}
}

