% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shiny.R
\name{session}
\alias{session}
\title{Session object}
\value{
\item{clientData}{
  A \code{\link{reactiveValues}} object that contains information about the client.
  \itemize{
    \item{\code{allowDataUriScheme} is a logical value that indicates whether
      the browser is able to handle URIs that use the \code{data:} scheme.
    }
    \item{\code{pixelratio} reports the "device pixel ratio" from the web browser,
      or 1 if none is reported. The value is 2 for Apple Retina displays.
    }
    \item{\code{singletons} - for internal use}
    \item{\code{url_protocol}, \code{url_hostname}, \code{url_port},
      \code{url_pathname}, \code{url_search}, and \code{url_hash_initial}
      can be used to get the components of the URL that was requested by the
      browser to load the Shiny app page. These values are from the
      browser's perspective, so neither HTTP proxies nor Shiny Server will
      affect these values. The \code{url_search} value may be used with
      \code{\link{parseQueryString}} to access query string parameters.
    }
  }
  \code{clientData} also contains information about each output.
  \code{output_\var{outputId}_width} and \code{output_\var{outputId}_height}
  give the dimensions (using \code{offsetWidth} and \code{offsetHeight}) of
  the DOM element that is bound to \code{\var{outputId}}, and
  \code{output_\var{outputId}_hidden} is a logical that indicates whether
  the element is hidden. These values may be \code{NULL} if the output is
  not bound.
}
\item{input}{
  The session's \code{input} object (the same as is passed into the Shiny
  server function as an argument).
}
\item{isClosed()}{A function that returns \code{TRUE} if the client has
  disconnected.
}
\item{onEnded(callback)}{
  Synonym for \code{onSessionEnded}.
}
\item{onFlush(func, once=TRUE)}{
  Registers a function to be called before the next time (if \code{once=TRUE})
  or every time (if \code{once=FALSE}) Shiny flushes the reactive system.
  Returns a function that can be called with no arguments to cancel the
  registration.
}
\item{onFlushed(func, once=TRUE)}{
  Registers a function to be called after the next time (if \code{once=TRUE})
  or every time (if \code{once=FALSE}) Shiny flushes the reactive system.
  Returns a function that can be called with no arguments to cancel the
  registration.
}
\item{onSessionEnded(callback)}{
  Registers a function to be called after the client has disconnected.
  Returns a function that can be called with no arguments to cancel the
  registration.
}
\item{output}{
  The session's \code{output} object (the same as is passed into the Shiny
  server function as an argument).
}
\item{reactlog}{
  For internal use.
}
\item{registerDataObj(name, data, filterFunc)}{
  Publishes any R object as a URL endpoint that is unique to this session.
  \code{name} must be a single element character vector; it will be used
  to form part of the URL. \code{filterFunc} must be a function that takes
  two arguments: \code{data} (the value that was passed into
  \code{registerDataObj}) and \code{req} (an environment that implements
  the Rook specification for HTTP requests). \code{filterFunc} will be
  called with these values whenever an HTTP request is made to the URL
  endpoint. The return value of \code{filterFunc} should be a Rook-style
  response.
}
\item{request}{
  An environment that implements the Rook specification for HTTP requests.
  This is the request that was used to initiate the websocket connection
  (as opposed to the request that downloaded the web page for the app).
}
\item{sendCustomMessage(type, message)}{
  Sends a custom message to the web page. \code{type} must be a
  single-element character vector giving the type of message, while
  \code{message} can be any jsonlite-encodable value. Custom messages
  have no meaning to Shiny itself; they are used soley to convey information
  to custom JavaScript logic in the browser. You can do this by adding
  JavaScript code to the browser that calls
  \code{Shiny.addCustomMessageHandler(type, function(message){...})}
  as the page loads; the function you provide to
  \code{addCustomMessageHandler} will be invoked each time
  \code{sendCustomMessage} is called on the server.
}
\item{sendInputMessage(inputId, message)}{
  Sends a message to an input on the session's client web page; if the input
  is present and bound on the page at the time the message is received, then
  the input binding object's \code{receiveMessage(el, message)} method will
  be called. \code{sendInputMessage} should generally not be called directly
  from Shiny apps, but through friendlier wrapper functions like
  \code{\link{updateTextInput}}.
}
}
\description{
Shiny server functions can optionally include \code{session} as a parameter
(e.g. \code{function(input, output, session)}). The session object is an
environment that can be used to access information and functionality
relating to the session. The following list describes the items available
in the environment; they can be accessed using the \code{$} operator (for
example, \code{session$clientData$url_search}).
}

