\name{installExprFunction}
\alias{installExprFunction}
\title{Installs an expression in the given environment as a function, and registers
debug hooks so that breakpoints may be set in the function.}
\usage{
  installExprFunction(expr, name,
    eval.env = parent.frame(2), quoted = FALSE,
    assign.env = parent.frame(1),
    label = as.character(sys.call(-1)[[1]]))
}
\arguments{
  \item{expr}{A quoted or unquoted expression}

  \item{name}{The name the function should be given}

  \item{eval.env}{The desired environment for the function.
  Defaults to the calling environment two steps back.}

  \item{quoted}{Is the expression quoted?}

  \item{assign.env}{The environment in which the function
  should be assigned.}

  \item{label}{A label for the object to be shown in the
  debugger. Defaults to the name of the calling function.}
}
\description{
  This function can replace \code{exprToFunction} as
  follows: we may use \code{func <- exprToFunction(expr)}
  if we do not want the debug hooks, or
  \code{installExprFunction(expr, "func")} if we do. Both
  approaches create a function named \code{func} in the
  current environment.
}
\seealso{
  Wraps \code{exprToFunction}; see that method's
  documentation for more documentation and examples.
}

