% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-layout.R
\name{verticalLayout}
\alias{verticalLayout}
\title{Lay out UI elements vertically}
\usage{
verticalLayout(..., fluid = TRUE)
}
\arguments{
\item{...}{Elements to include within the container}

\item{fluid}{\code{TRUE} to use fluid layout; \code{FALSE} to use fixed
layout.}
}
\description{
Create a container that includes one or more rows of content (each element
passed to the container will appear on it's own line in the UI)
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  verticalLayout(
    a(href="http://example.com/link1", "Link One"),
    a(href="http://example.com/link2", "Link Two"),
    a(href="http://example.com/link3", "Link Three")
  )
)
shinyApp(ui, server = function(input, output) { })
}
}
\seealso{
Other layout functions: 
\code{\link{fillPage}()},
\code{\link{fixedPage}()},
\code{\link{flowLayout}()},
\code{\link{fluidPage}()},
\code{\link{navbarPage}()},
\code{\link{sidebarLayout}()},
\code{\link{splitLayout}()}
}
\concept{layout functions}
