% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renders.R
\name{cb_ui}
\alias{cb_ui}
\alias{cb_server}
\title{Include filtering panel in Shiny}
\usage{
cb_ui(
  id,
  ...,
  state = FALSE,
  steps = TRUE,
  code = TRUE,
  attrition = TRUE,
  new_step = c("clone", "configure")
)

cb_server(
  id,
  cohort,
  run_button = "none",
  stats = c("pre", "post"),
  feedback = FALSE,
  enable_bookmarking = shiny::getShinyOption("bookmarkStore", default = "disable"),
  show_help = TRUE,
  ...
)
}
\arguments{
\item{id}{Id of the module used to render the panel.}

\item{...}{Extra attributes passed to the panel div container.}

\item{state}{Set to TRUE (default) to enable get/set state panel.}

\item{steps}{Set to TRUE (default) if multiple steps should be available.}

\item{code}{Set to TRUE (default) to enable reproducible code panel.}

\item{attrition}{Set to TRUE (default) to enable attrition plot panel.}

\item{new_step}{Choose which add step method should be used for creating new step.
Possible options are: "clone" - copy filters from last step,
"configure" - opening modal and allow to chose filters from available filters.}

\item{cohort}{Cohort object storing filtering steps configuration.}

\item{run_button}{Should Run button be displayed? If so, the current step computations are run only when clicked.
Three options are available "none" - no button, "local" - button displayed at each step panel,
"global" - button visible in top filtering panel.}

\item{stats}{Choose which statistics should be displayed for data (and some filters).
Possible options are: "pre" - previous step stat, "post" - current step stats,
`c("pre", "post")` - for both and NULL for no stats.}

\item{feedback}{Set to TRUE (default) if feedback plots should be displayed at each filter.}

\item{enable_bookmarking}{Set to TRUE (default) if panel should be compatible with native shiny bookmarking.}

\item{show_help}{Set to TRUE (default) to enable help buttons.}
}
\value{
Nested list of `shiny.tag` objects - html structure of filtering panel module.

`shiny::moduleServer` output providing server logic for filtering panel module.
}
\description{
The function returns filtering panel placeholder, you may use in you custom Shiny application.
Use in the UI part of your application.
}
\examples{
if (interactive()) {
  library(cohortBuilder)
  library(shiny)
  library(shinyCohortBuilder)

  librarian_source <- set_source(as.tblist(librarian))
  librarian_cohort <- cohort(
    librarian_source,
    filter(
      "discrete", id = "author", dataset = "books",
      variable = "author", value = "Dan Brown",
      active = FALSE
    ),
    filter(
      "range", id = "copies", dataset = "books",
      variable = "copies", range = c(5, 10),
      active = FALSE
    ),
    filter(
      "date_range", id = "registered", dataset = "borrowers",
      variable = "registered", range = c(as.Date("2010-01-01"), Inf),
      active = FALSE
    )
  )

  ui <- fluidPage(
    sidebarLayout(
      sidebarPanel(
        cb_ui("librarian")
      ),
      mainPanel()
    )
  )

  server <- function(input, output, session) {
    cb_server("librarian", librarian_cohort)
  }

  shinyApp(ui, server)
}

}
