% Generated by roxygen2 (4.0.1): do not edit by hand
\name{shinyFileChoose}
\alias{shinyFileChoose}
\title{Creates a reactive expression that updates the filesystem view}
\usage{
shinyFileChoose(input, inputId, updateFreq = 2000, session = NULL, ...)
}
\arguments{
\item{input}{The input object of the \code{shinyServer()} call (usaully
\code{input})}

\item{inputId}{The same ID as used in the matching call to
\code{shinyFilesButton} or as the id attribute of the button, in case of a
manually defined html.}

\item{updateFreq}{The time in milliseconds between file system lookups. This
determines the responsiveness to changes in the filesystem (e.g. addition of
files or drives)}

\item{session}{The session object of the shinyServer call (usually
'session'). Used to terminate file system lookups when the client leaves.}

\item{...}{Arguments to be passed on to \code{\link{fileGetter}}}
}
\value{
A reactive expression that should be assigned to the output object of
the \code{shinyServer()} call. The output name it should be assigned to have
to match the provided \code{inputId}
}
\description{
This function sets up the required connection to the client in order for the
user to navigate the filesystem. For this to work a matching button should be
present in the html, either by using \code{shinyFilesButton()} or adding it
manually. See \code{\link{shinyFilesButton}} for more information on this.
}
\details{
Restrictions on the access rights of the client can be given in several ways.
The root parameter specifies the starting position for the filesystem as
presented to the client. This means that the client can only navigate in
subdirectories of the root. Paths passed of to the \code{restrictions}
parameter will not show up in the client view, and it is impossible to
navigate into these subdirectories. The \code{filetypes} parameter takes a
vector of of file extensions to filter the output on, so that the client is
only presented with these filetypes. The \code{hidden} parameter toggles
whether hidden files should be visible or not.
}
\examples{
\dontrun{
ui <- shinyUI(bootstrapPage(
    shinyFilesButton('files', 'File select', 'Please select a file', FALSE)
))
server <- shinyServer(function(input, output, session) {
    output$files <- shinyFileChoose(input, 'files', session=session,
    roots=c(wd='.'), filetypes=c('', '.txt'))
})

runApp(list(
    ui=ui,
    server=server
))
}
}
\seealso{
Other shinyFiles: \code{\link{parseFilePaths}};
  \code{\link{shinyFilesButton}};
  \code{\link{shinyFilesExample}}
}

