% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valueButton.R
\name{valueButton}
\alias{valueButton}
\alias{valueLink}
\title{Take value from selected UI element}
\usage{
valueButton(
  inputId,
  label,
  selector,
  attribute = "value",
  icon = NULL,
  width = NULL,
  ...
)

valueLink(inputId, label, selector, attribute = "value", icon = NULL, ...)
}
\arguments{
\item{inputId}{Id of the button. The value can be accessed in server with `input[[inputId]]`.}

\item{label}{Button label.}

\item{selector}{CSS selector of element the attribute should be taken from.
Set `"window"` or `"document"` to access application `window` or `document` object.}

\item{attribute}{Name of the attribute that should be taken from desired element.
For nested properties use `.`, e.g. `style.width` or `navigator.appName`.}

\item{icon}{Icon included in button.}

\item{width}{Width of the button.}

\item{...}{Extra attributes passed to `button` or `a` tag.}
}
\value{
A `shiny.tag` class object defining html structure of the button.
}
\description{
The components creates button or link that allows to take any value (or attribute) sourced
from DOM element existing in Shiny application and pass it to application server.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      tags$textarea(id = "txt"),
      valueButton("val", "Take textarea value", "#txt", attribute = "value")
    ),
    server = function(input, output, session) {
      observeEvent(input$val, print(input$val))
    }
  )
}

}
