% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{header}
\alias{header}
\title{Header Function}
\usage{
header(
  main_text,
  secondary_text,
  logo = NULL,
  main_link = "#",
  secondary_link = "#"
)
}
\arguments{
\item{main_text}{Main text that goes in the header}

\item{secondary_text}{Secondary header to supplement the main text}

\item{logo}{Add a link to a logo which will apply in the header.}

\item{main_link}{Add a link for clicking on main text}

\item{secondary_link}{Add a link for clicking on secondary header.}
}
\value{
a header html shiny object
}
\description{
This function create a header banner.  For use at top of the screen
}
\examples{
if (interactive()) {

  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png")
  )

  server <- function(input, output, session) {}

  shinyApp(ui = ui, server = server)
}
}
\keyword{header}
