% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backlink_Input.R
\name{backlink_Input}
\alias{backlink_Input}
\title{Back Link Function}
\usage{
backlink_Input(inputId)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}
}
\value{
a backlink html shiny object
}
\description{
This function adds a back link to the page
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shiny::navlistPanel(
      "",
      id="nav",
      widths = c(2, 10),
      well = FALSE,

      #Create first panel
      shiny::tabPanel(
        "Select Types",
        value = "panel1",
        gov_layout(size = "two-thirds",
          backlink_Input("link1"),
          shiny::tags$br(), shiny::tags$br()
       )),
       shiny::tabPanel(
         "Tab2",
         value = "panel2")),
   shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {
    #Slightly confused in that it goes forward rather than back, but shows how
    #to use
    observeEvent(input$link1,{
      updateTabsetPanel(session, "nav", selected = "panel2")
    })
  }
  shinyApp(ui = ui, server = server)
}
}
\keyword{backlink}
