% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{gov_summary}
\alias{gov_summary}
\title{Tabs Function}
\usage{
gov_summary(inputId, headers, info, action = FALSE, border = TRUE)
}
\arguments{
\item{inputId}{The id to access the summary list}

\item{headers}{input for the row headers value}

\item{info}{summary information values for the table}

\item{action}{whenever a change link is needed.  sets input to the value of
the headers using lowercase and with underscore to replace gaps. Default
set to \code{FALSE}}

\item{border}{set if the table should have borders.  Default set
to \code{TRUE}}
}
\value{
a summary list table html shiny object.
}
\description{
This function creates a tabs based table.  It requires a single dataframe
with a grouping variable
}
\examples{
if (interactive()) {

  # Create an example dataset
  headers <- c("Name", "Date of birth", "Contact information", "Contact details")
  info <- c(
    "Sarah Philips",
    "5 January 1978",
    "72 Guild Street <br> London <br> SE23 6FH",
    "07700 900457 <br> sarah.phillips@example.com")

  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::gov_layout(size = "two-thirds",
      shinyGovstyle::gov_summary("sumID", headers, info, action = FALSE)),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {}
  shinyApp(ui = ui, server = server)
}

}
\keyword{list}
\keyword{summary}
