% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_downsampler.R
\name{apply_downsampler}
\alias{apply_downsampler}
\alias{apply_downsampler.numeric}
\alias{apply_downsampler.data.frame}
\title{Wrapper for applying down-sampling}
\usage{
apply_downsampler(obj, ...)

\method{apply_downsampler}{numeric}(obj, n_out = 1000L, aggregator = eLTTB_aggregator, ...)

\method{apply_downsampler}{data.frame}(obj, n_out = 1000L, aggregator = eLTTB_aggregator, ...)
}
\arguments{
\item{obj}{Numeric vector or data.frame.
If a numeric vector is given, a specific down-sampling method will be
employed and a down-sampled vector will be returned.
If a data.frame is given, a specific down-sampling method will be employed
using \code{x} and \code{y} columns and a down-sampled data.frame
will be returned.}

\item{...}{Not used.}

\item{n_out}{Integer, optional.
Number of samples get by the down-sampling. By default, 1000.}

\item{aggregator}{R6 class for the aggregation, optional.
Select one out of
\code{LTTB_aggregator}, \code{min_max_ovlp_aggregator},
\code{min_max_aggregator}, \code{eLTTB_aggregator},
\code{nth_pnt_aggregator}, \code{custom_stat_aggregator},
\code{mean_aggregator}, \code{median_aggregator},
\code{min_aggregator}, \code{max_aggregator},
or \code{custom_func_aggregator}.
By default \code{eLTTB_aggregator}.}
}
\description{
This function is a wrapper that employs an aggregator.
}
\examples{
data(noise_fluct)

y_agg <- apply_downsampler(noise_fluct$level)

d_agg <- noise_fluct \%>\%
  dplyr::select(x = sec, y = level) \%>\%
  apply_downsampler()

}
