% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_downsampler.R
\docType{class}
\name{shiny_downsampler}
\alias{shiny_downsampler}
\title{R6 Class implementing down-sampling in shiny app}
\format{
An \code{R6::R6Class} object
}
\description{
This class includes high-frequency original data, plotly figure, and shiny.
The plotly figure will be made by initializing the instance and using
\code{add_trace} method.
(note that the method is different from \code{plotly::add_trace}).
The easiest way to run shiny app is using \code{show_shiny} method.
Or, you can register the figures using \code{register_figures} method
then you can run the app using \code{run_server} method.
}
\examples{
\donttest{
library(plotly)
data(noise_fluct)
p <- plot_ly(noise_fluct) \%>\%
  add_trace(x = ~sec, y = ~level, type = "scatter", mode = "lines")
d_app <- shiny_downsampler$new(p)
d_app$show_shiny()
}
}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_downsampler]{shinyHugePlot::abstract_downsampler}} -> \code{shiny_downsampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{shiny_session}}{ShinySession R6 instance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-shiny_downsampler-new}{\code{shiny_downsampler$new()}}
\item \href{#method-shiny_downsampler-update_figure_data}{\code{shiny_downsampler$update_figure_data()}}
\item \href{#method-shiny_downsampler-show_shiny}{\code{shiny_downsampler$show_shiny()}}
\item \href{#method-shiny_downsampler-clone}{\code{shiny_downsampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="add_trace"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-add_trace'><code>shinyHugePlot::abstract_downsampler$add_trace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="get_figure_data"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-get_figure_data'><code>shinyHugePlot::abstract_downsampler$get_figure_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-new}{}}}
\subsection{Method \code{new()}}{
Create a new downsampler
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$new(
  figure = plotly::plot_ly(),
  is_downsample = TRUE,
  n_out = 1000L,
  aggregator = eLTTB_aggregator$new(),
  legend_options = list(downsample_prefix = "<b style=\\"color:sandybrown\\">[R]</b> ",
    downsample_suffix = "", is_aggsize_shown = TRUE, agg_prefix =
    " <i style=\\"color:#fc9944\\">~", agg_suffix = "</i>"),
  tz = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure, is_downsample, n_out, aggregator, legend_options, tz}}{Arguments pass to the constructor of
the \code{abstract_downsampler} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-update_figure_data"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-update_figure_data}{}}}
\subsection{Method \code{update_figure_data()}}{
update the trace data according to the relayout order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$update_figure_data(relayout_order = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relayout_order}}{Named list.
The list is generated by converging the dictionary
obtained from \code{plotlyjs_relayout}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-show_shiny"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-show_shiny}{}}}
\subsection{Method \code{show_shiny()}}{
Easily output the shiny app.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$show_shiny(shiny_options = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shiny_options}}{Named list.
Arguments passed to \code{shinyApp} as the options.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
