% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregator.R
\docType{class}
\name{aggregator}
\alias{aggregator}
\title{R6 base class for the aggregation}
\format{
An \code{R6::R6Class} object
}
\description{
A base class for the aggregation,
which defines the structure of the class and
is not available on a stand-alone basis.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{interleave_gaps}}{Boolean.
Whether \code{NA} values should be added
when there are gaps / irregularly sampled data}

\item{\code{accepted_datatype}}{Character.
Classes that can be handled with the aggregator.}

\item{\code{nan_position}}{Character.
Where \code{NA}s are placed when gaps are detected.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-aggregator-new}{\code{aggregator$new()}}
\item \href{#method-aggregator-aggregate}{\code{aggregator$aggregate()}}
\item \href{#method-aggregator-clone}{\code{aggregator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of abstract_aggregator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{aggregator$new(
  interleave_gaps = FALSE,
  nan_position = "end",
  accepted_datatype = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps}}{Boolean, optional.
Whether \code{NA} values should be added
when there are gaps / irregularly sampled data.
Gaps and irregular samples are detected with a quantile-based approach.
By default, \code{FALSE}.}

\item{\code{nan_position}}{Character, optional.
Indicates where \code{NA}s are placed when gaps are detected.
If \code{"end"}, the first point after a gap will be replaced.
If \code{"begin"}, the last point before a gap will be replaced.
If \code{"both"}, both the encompassing gap data points are replaced.
This parameter is only effective
when \code{interleave_gaps == TRUE}.}

\item{\code{accepted_datatype}}{Character, optional.
This parameter indicates the supported data classes.
If all data classes are accepted, set it to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregator-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-aggregator-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Aggregates the given input and returns samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{aggregator$aggregate(x, y, n_out)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y}}{Indexes and values that has to be aggregated.}

\item{\code{n_out}}{Integer or numeric.
The number of samples that the aggregated data contains.
Generate a matrix using x and n_out
Apply function for nanotime}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
