% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyML_classification.R
\name{shinyML_classification}
\alias{shinyML_classification}
\title{Implement a shiny web app to compare h2o and Spark supervised machine learning models for classification tasks}
\usage{
shinyML_classification(
  data = data,
  y,
  framework = "h2o",
  share_app = FALSE,
  port = NULL
)
}
\arguments{
\item{data}{dataset containing one or more explanatory variables and one categorical variable to predict. 
The dataset must be a data.frame or a data.table and can contain time-based column on Date or POSIXct format}

\item{y}{the categorical output variable to predict (must correspond to one data column)}

\item{framework}{the machine learning framework chosen to train and test models (either h2o or Spark). h2o by default}

\item{share_app}{a logical value indicating whether the app must be shared on local LAN}

\item{port}{a four-digit number corresponding to the port the application should listen to. This parameter is necessary only  if share_app option is set to TRUE}
}
\description{
This function creates in one line of code a shareable web app to compare supervised classification model performances
}
\examples{
\dontrun{
library(shinyML)
shinyML_classification(data = iris,y = "Species",framework = "h2o")
}
}
\author{
Jean Bertin, \email{jean.bertin@mines-paris.org}
}
