% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Gauge.R
\name{updateF7Gauge}
\alias{updateF7Gauge}
\title{update a framework7 gauge from the server side}
\usage{
updateF7Gauge(session, id, value)
}
\arguments{
\item{session}{Shiny session object.}

\item{id}{Gauge id.}

\item{value}{New value. Numeric between 0 and 100.}
}
\description{
update a framework7 gauge from the server side
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)


 shiny::shinyApp(
    ui = f7Page(
       title = "Gauges",
       f7SingleLayout(
          navbar = f7Navbar(title = "update f7Gauge"),
          f7Gauge(
             id = "mygauge",
             type  = "semicircle",
             value = 50,
             borderColor = "#2196f3",
             borderWidth = 10,
             valueText = "50\%",
             valueFontSize = 41,
             valueTextColor = "#2196f3",
             labelText = "amount of something"
          ),
          f7Button("go", "Update Gauge")
       )
    ),
    server = function(input, output, session) {
       observeEvent(input$go, {
          updateF7Gauge(session, id = "mygauge", value = 75)
       })
    }
 )
}
}
