% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Stepper}
\alias{updateF7Stepper}
\title{Change the value of a stepper input on the client}
\usage{
updateF7Stepper(
  session,
  inputId,
  min = NULL,
  max = NULL,
  value = NULL,
  step = NULL,
  fill = NULL,
  rounded = NULL,
  raised = NULL,
  size = NULL,
  color = NULL,
  wraps = NULL,
  autorepeat = NULL,
  manual = NULL
)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{min}{Stepper minimum value.}

\item{max}{Stepper maximum value.}

\item{value}{Stepper value. Must belong to \[min, max\].}

\item{step}{increment step. 1 by default.}

\item{fill}{Whether to fill the stepper. FALSE by default.}

\item{rounded}{Whether to round the stepper. FALSE by default.}

\item{raised}{Whether to put a relied around the stepper. FALSE by default.}

\item{size}{Stepper size: "small", "large" or NULL.}

\item{color}{Stepper color: NULL or "red", "green", "blue", "pink", "yellow", "orange", "grey" and "black".}

\item{wraps}{In wraps mode incrementing beyond maximum value sets value to minimum value,
likewise, decrementing below minimum value sets value to maximum value. FALSE by default.}

\item{autorepeat}{Pressing and holding one of its buttons increments or decrements the stepper’s
value repeatedly. With dynamic autorepeat, the rate of change depends on how long the user
continues pressing the control. TRUE by default.}

\item{manual}{It is possible to enter value manually from keyboard or mobile keypad. When click on input field, stepper enter into manual input mode, which allow type value from keyboar and check fractional part with defined accurancy. Click outside or enter Return key, ending manual mode. TRUE by default.}
}
\description{
Change the value of a stepper input on the client
}
\note{
While updating, the autorepeat field does not work correctly.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Stepper"),
      f7Card(
        f7Button(inputId = "update", label = "Update stepper"),
        f7Stepper(
          inputId = "stepper",
          label = "My stepper",
          min = 0,
          max = 10,
          size = "small",
          value = 4,
          wraps = TRUE,
          autorepeat = TRUE,
          rounded = FALSE,
          raised = FALSE,
          manual = FALSE
        ),
        verbatimTextOutput("test")
      )
    )
  ),
  server = function(input, output, session) {

    output$test <- renderPrint(input$stepper)

    observeEvent(input$update, {
      updateF7Stepper(
        session,
        inputId = "stepper",
        value = 10,
        size = "large",
        min = 5,
        max = 20,
        wraps = FALSE,
        autorepeat = FALSE,
        rounded = TRUE,
        raised = TRUE,
        color = "pink",
        manual = TRUE
      )
    })
  }
 )
}
}
