% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{updateF7Tabs}
\alias{updateF7Tabs}
\title{Update a Framework 7 tabsetPanel}
\usage{
updateF7Tabs(session, id, selected = NULL)
}
\arguments{
\item{session}{Shiny session object.}

\item{id}{Id of the \link{f7Tabs} to update.}

\item{selected}{Newly selected tab.}
}
\description{
Update \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
   ui = f7Page(
     title = "Tab Layout",
     f7TabLayout(
       navbar = f7Navbar(
        title = HTML(paste("Currently selected:", textOutput("selected"))),
        subNavbar = f7SubNavbar(
         f7Flex(
          f7Toggle(inputId = "updateTab", label = "Update Tab", checked = TRUE),
          f7Toggle(inputId = "updateSubTab", label = "Update SubTab", checked = FALSE)
         )
        )
       ),
       f7Tabs(
         id = "tabdemo",
         swipeable = TRUE,
         animated = FALSE,
         f7Tab(
          tabName = "Tab 1",
          f7Tabs(
           id = "subtabdemo",
           animated = TRUE,
           f7Tab(tabName = "SubTab 1", "SubTab 1"),
           f7Tab(tabName = "SubTab 2", "SubTab 2", active = TRUE),
           f7Tab(tabName = "SubTab 3", "SubTab 3")
          )
         ),
         f7Tab(tabName = "Tab 2", "Tab 2"),
         f7Tab(tabName = "Tab 3", "Tab 3")
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$updateTab, {
       selected <- ifelse(input$updateTab, "Tab 1", "Tab 2")
       updateF7Tabs(session, id = "tabdemo", selected = selected)
     })
     observeEvent(input$updateSubTab, {
       selected <- ifelse(input$updateSubTab, "SubTab 1", "SubTab 2")
       updateF7Tabs(session, id = "subtabdemo", selected = selected)
     })
   }
 )
}
}
