% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Appbar.R
\name{f7Appbar}
\alias{f7Appbar}
\title{Create a Framework 7 appbar}
\usage{
f7Appbar(..., left_panel = FALSE, right_panel = FALSE)
}
\arguments{
\item{...}{Any UI content such as \link{f7Searchbar}, \link{f7Next} and
\link{f7Back}. It is best practice to wrap \link{f7Next} and
\link{f7Back} in a \link{f7Flex}.}

\item{left_panel}{Whether to enable the left panel. FALSE by default.}

\item{right_panel}{Whether to enable the right panel. FALSE by default.}
}
\description{
Displayed on top of \link{f7Navbar}. Interestingly, \link{f7Appbar} can also
trigger \link{f7Panel}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 cities <- names(precip)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7Appbar(
       f7Flex(f7Back(targetId = "tabset"),f7Next(targetId = "tabset")),
       f7Searchbar(id = "search1", inline = TRUE)
     ),
     f7TabLayout(
       navbar = f7Navbar(
         title = "f7Appbar",
         hairline = FALSE,
         shadow = TRUE
       ),
       f7Tabs(
         animated = FALSE,
         swipeable = TRUE,
         id = "tabset",
         f7Tab(
           tabName = "Tab 1",
           icon = f7Icon("envelope"),
           active = TRUE,
           "Text 1"
         ),
         f7Tab(
           tabName = "Tab 2",
           icon = f7Icon("today"),
           active = FALSE,
           "Text 2"
         ),
         f7Tab(
           tabName = "Tab 3",
           icon = f7Icon("cloud_upload"),
           active = FALSE,
           "Text 3"
         )
       )
     )
   ),
   server = function(input, output) {}
 )
}
}
