% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7AutoComplete}
\alias{updateF7AutoComplete}
\title{Change the value of an autocomplete input on the client}
\usage{
updateF7AutoComplete(
  inputId,
  value = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{value}{Picker new value.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
Change the value of an autocomplete input on the client
}
\note{
You cannot update choices yet.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update autocomplete"),
      f7Card(
        f7Button(inputId = "update", label = "Update autocomplete"),
        f7AutoComplete(
         inputId = "myautocomplete",
         placeholder = "Some text here!",
         openIn = "dropdown",
         label = "Type a fruit name",
         choices = c('Apple', 'Apricot', 'Avocado', 'Banana', 'Melon',
                     'Orange', 'Peach', 'Pear', 'Pineapple')
        ),
        verbatimTextOutput("autocompleteval")
      )
    )
  ),
  server = function(input, output, session) {

    observe({
     print(input$myautocomplete)
    })

    output$autocompleteval <- renderText(input$myautocomplete)

    observeEvent(input$update, {
      updateF7AutoComplete(
        inputId = "myautocomplete",
        value = "Banana"
      )
    })
  }
 )
}
}
