% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Stepper}
\alias{f7Stepper}
\alias{updateF7Stepper}
\title{Framework7 stepper input}
\usage{
f7Stepper(
  inputId,
  label,
  min,
  max,
  value,
  step = 1,
  fill = FALSE,
  rounded = FALSE,
  raised = FALSE,
  size = NULL,
  color = NULL,
  wraps = FALSE,
  autorepeat = TRUE,
  manual = FALSE,
  decimalPoint = 4,
  buttonsEndInputMode = TRUE
)

updateF7Stepper(
  inputId,
  min = NULL,
  max = NULL,
  value = NULL,
  step = NULL,
  fill = NULL,
  rounded = NULL,
  raised = NULL,
  size = NULL,
  color = NULL,
  wraps = NULL,
  decimalPoint = NULL,
  autorepeat = NULL,
  manual = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Stepper label.}

\item{min}{Stepper minimum value.}

\item{max}{Stepper maximum value.}

\item{value}{Stepper value. Must belong to \[min, max\].}

\item{step}{increment step. 1 by default.}

\item{fill}{Whether to fill the stepper. FALSE by default.}

\item{rounded}{Whether to round the stepper. FALSE by default.}

\item{raised}{Whether to put a relied around the stepper. FALSE by default.}

\item{size}{Stepper size: "small", "large" or NULL.}

\item{color}{Stepper color: NULL or "red", "green", "blue", "pink", "yellow", "orange", "grey" and "black".}

\item{wraps}{In wraps mode incrementing beyond maximum value sets value to minimum value,
likewise, decrementing below minimum value sets value to maximum value. FALSE by default.}

\item{autorepeat}{Pressing and holding one of its buttons increments or decrements the stepper’s
value repeatedly. With dynamic autorepeat, the rate of change depends on how long the user
continues pressing the control. TRUE by default.}

\item{manual}{It is possible to enter value manually from keyboard or mobile keypad.
When click on input field, stepper enter into manual input mode, which allow type value
from keyboar and check fractional part with defined accurancy. Click outside or enter
Return key, ending manual mode. TRUE by default.}

\item{decimalPoint}{Number of digits after dot, when in manual input mode.}

\item{buttonsEndInputMode}{Disables manual input mode on Stepper's minus or plus button click.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\link{f7Stepper} creates a stepper input.

\link{updateF7Stepper} changes the value of a stepper input on the client.
}
\note{
While updating, the autorepeat field does not work correctly.
}
\examples{
# Stepper input
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Stepper"),
     f7Stepper(
      inputId = "stepper",
      label = "My stepper",
      min = 0,
      max = 10,
      value = 4
     ),
     verbatimTextOutput("test"),
     f7Stepper(
      inputId = "stepper2",
      label = "My stepper 2",
      min = 0,
      max = 10,
      value = 4,
      color = "orange",
      raised = TRUE,
      fill = TRUE,
      rounded = TRUE
     ),
     verbatimTextOutput("test2")
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint(input$stepper)
    output$test2 <- renderPrint(input$stepper2)
   }
 )
}
# Update stepper input
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Stepper"),
      f7Card(
        f7Button(inputId = "update", label = "Update stepper"),
        f7Stepper(
          inputId = "stepper",
          label = "My stepper",
          min = 0,
          max = 10,
          size = "small",
          value = 4,
          wraps = TRUE,
          autorepeat = TRUE,
          rounded = FALSE,
          raised = FALSE,
          manual = FALSE
        ),
        verbatimTextOutput("test")
      )
    )
  ),
  server = function(input, output, session) {

    output$test <- renderPrint(input$stepper)

    observeEvent(input$update, {
      updateF7Stepper(
        inputId = "stepper",
        value = 0.1,
        step = 0.01,
        size = "large",
        min = 0,
        max = 1,
        wraps = FALSE,
        autorepeat = FALSE,
        rounded = TRUE,
        raised = TRUE,
        color = "pink",
        manual = TRUE,
        decimalPoint = 2
      )
    })
  }
 )
}
}
