% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Checkbox}
\alias{f7Checkbox}
\alias{updateF7Checkbox}
\title{Framework7 checkbox}
\usage{
f7Checkbox(inputId, label, value = FALSE)

updateF7Checkbox(
  inputId,
  label = NULL,
  value = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value (TRUE or FALSE).}

\item{session}{The Shiny session object.}
}
\description{
\link{f7Checkbox} creates a checkbox input.

\code{updateF7Checkbox} changes the value of a checkbox input on the client.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Checkbox"),
      f7Block(f7Button("update", "Toggle checkbox")),
      f7Checkbox(
        inputId = "checkbox",
        label = "Checkbox",
        value = FALSE
      )
    )
  ), server = function(input, output, session) {
    observeEvent(input$update, {
      updateF7Checkbox("checkbox", value = !input$checkbox)
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
