% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Badge.R
\name{f7Badge}
\alias{f7Badge}
\title{Framework7 badge}
\usage{
f7Badge(..., color = NULL)
}
\arguments{
\item{...}{Badge content. Avoid long text.}

\item{color}{Badge color: see here for valid colors \url{https://framework7.io/docs/badge.html}.}
}
\description{
Container to highlight important information with color.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  colors <- getF7Colors()

  shinyApp(
    ui = f7Page(
      title = "Badges",
      f7SingleLayout(
        navbar = f7Navbar(title = "f7Badge"),
        f7Block(
          strong = TRUE,
          f7Badge("Default"),
          lapply(seq_along(colors), function(i) {
            f7Badge(colors[[i]], color = colors[[i]])
          })
        )
      )
    ),
    server = function(input, output) {}
  )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
