% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7TapHold.R
\name{f7TapHold}
\alias{f7TapHold}
\title{Framework7 tapHold module}
\usage{
f7TapHold(target, callback, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{target}{Element to apply the tapHold event on. Must be a jQuery selector,
such as "#id" or ".class", ".class1, .class2", "a"...}

\item{callback}{Javascript callback.}

\item{session}{Shiny session object.}
}
\description{
Framework7 has a so called "tap hold" event. If tapHold is enabled in \link{f7Page}, it triggers
after a sustained, complete touch event. \link{f7TapHold} is triggered from the server.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Taphold",
    f7SingleLayout(
      navbar = f7Navbar(title = "f7TapHold"),
      f7Button(inputId = "pressme", label = "Press me")
    )
  ),
  server = function(input, output, session) {
    observe({
      f7TapHold(
        target = "#pressme",
        callback = "app.dialog.alert('Tap hold fired!')"
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
