% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Toggle}
\alias{f7Toggle}
\alias{updateF7Toggle}
\title{Framework7 toggle input}
\usage{
f7Toggle(inputId, label, checked = FALSE, color = NULL)

updateF7Toggle(
  inputId,
  checked = NULL,
  color = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Toggle input id.}

\item{label}{Toggle label.}

\item{checked}{Whether to check the toggle. FALSE by default.}

\item{color}{Toggle color: NULL or "primary", "red", "green", "blue",
"pink", "yellow", "orange", "purple", "deeppurple", "lightblue",
"teal, "lime", "deeporange", "gray", "white", "black".}

\item{session}{The Shiny session object.}
}
\description{
\code{f7Toggle} creates a F7 toggle switch input.

\code{updateF7Toggle} changes the value of a toggle input on the client.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "f7Toggle",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Toggle"),
      f7Card(
        f7Button(inputId = "update", label = "Update toggle"),
        br(),
        f7Toggle(
          inputId = "toggle",
          label = "My toggle",
          color = "pink",
          checked = FALSE
        ),
        verbatimTextOutput("test")
      )
    )
  ),
  server = function(input, output, session) {
    output$test <- renderPrint({
      input$toggle
    })

    observeEvent(input$update, {
      updateF7Toggle(
        inputId = "toggle",
        checked = !input$toggle,
        color = "green"
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
