% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7VirtualList.R
\name{f7VirtualList}
\alias{f7VirtualList}
\alias{f7VirtualListItem}
\title{Framework7 virtual list}
\usage{
f7VirtualList(
  id,
  items,
  rowsBefore = NULL,
  rowsAfter = NULL,
  cache = TRUE,
  mode = NULL,
  inset = FALSE,
  outline = FALSE,
  dividers = FALSE,
  strong = FALSE
)

f7VirtualListItem(
  ...,
  id = NULL,
  title = NULL,
  subtitle = NULL,
  header = NULL,
  footer = NULL,
  href = NULL,
  media = NULL,
  right = NULL,
  routable = FALSE
)
}
\arguments{
\item{id}{Optional id for item.}

\item{items}{List items. Slot for \link{f7VirtualListItem}.}

\item{rowsBefore}{Amount of rows (items) to be rendered before current
screen scroll position. By default it is equal to double amount of
rows (items) that fit to screen.}

\item{rowsAfter}{Amount of rows (items) to be rendered after current
screen scroll position. By default it is equal to the amount of rows
(items) that fit to screen.}

\item{cache}{Disable or enable DOM cache for already rendered list items.
In this case each item will be rendered only once and all further
manipulations will be with DOM element. It is useful if your list
items have some user interaction elements (like form elements or swipe outs)
or could be modified.}

\item{mode}{List mode. NULL, "simple", "links", "media" or "contacts".}

\item{inset}{Whether to display a card border. FALSE by default.}

\item{outline}{Outline style. Default to FALSE.}

\item{dividers}{Dividers style. Default to FALSE.}

\item{strong}{Strong style. Default to FALSE.}

\item{...}{Item text.}

\item{title}{Item title.}

\item{subtitle}{Item subtitle.}

\item{header}{Item header.}

\item{footer}{Item footer.}

\item{href}{Item external link.}

\item{media}{Expect \link{f7Icon} or \code{img}.}

\item{right}{Right content if any.}

\item{routable}{Works when href is not NULL. Default to FALSE. If TRUE,
the list item may point to another page, but we recommend using \link{f7List}
and \link{f7ListItem} instead. See \link{f7MultiLayout}. Can also be used in
combination with href = "#" to make items appear as links, but not actually
navigate anywhere, which is useful for custom click events.}
}
\description{
\code{f7VirtualList} is a high performance list container.
Use if you have too many components in \link{f7List}.

\code{f7VirtualListItem} is an item component for \link{f7VirtualList}.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Virtual List",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Virtual Lists"
      ),
      # controls
      f7Segment(
        f7Button(inputId = "appendItem", "Append Item"),
        f7Button(inputId = "prependItems", "Prepend Items"),
        f7Button(inputId = "insertBefore", "Insert before"),
        f7Button(inputId = "replaceItem", "Replace Item")
      ),
      f7Segment(
        f7Button(inputId = "deleteAllItems", "Remove All"),
        f7Button(inputId = "moveItem", "Move Item"),
        f7Button(inputId = "filterItems", "Filter Items")
      ),
      f7Grid(
        cols = 3,
        uiOutput("itemIndexUI"),
        uiOutput("itemNewIndexUI"),
        uiOutput("itemsFilterUI")
      ),
      # searchbar
      f7Searchbar(id = "search1"),
      # main content
      f7VirtualList(
        id = "vlist",
        rowsBefore = 2,
        rowsAfter = 2,
        mode = "media",
        items = lapply(1:1000, function(i) {
          f7VirtualListItem(
            id = paste0("vlist-item-", i),
            title = paste("Title", i),
            subtitle = paste("Subtitle", i),
            header = paste("Header", i),
            footer = paste("Footer", i),
            right = paste("Right", i),
            paste0("Content", i),
            media = img(style = "border-radius: 8px",
                        src = "https://cdn.framework7.io/placeholder/fashion-88x88-1.jpg")
          )
        })
      )
    )
  ),
  server = function(input, output) {

    output$itemIndexUI <- renderUI({
      req(input$vlist$length > 2)
      f7Stepper(
        inputId = "itemIndex",
        label = "Index",
        min = 1,
        value = 2,
        max = input$vlist$length
      )
    })

    output$itemNewIndexUI <- renderUI({
      req(input$vlist$length > 2)
      f7Stepper(
        inputId = "itemNewIndex",
        label = "New Index",
        min = 1,
        value = 1,
        max = input$vlist$length
      )
    })

    output$itemsFilterUI <- renderUI({
      input$appendItem
      input$prependItems
      input$insertBefore
      input$replaceItem
      input$deleteAllItems
      input$moveItem
      isolate({
        req(input$vlist$length > 2)
        f7Slider(
          inputId = "itemsFilter",
          label = "Items to Filter",
          min = 1,
          max = input$vlist$length,
          value = c(1, input$vlist$length)
        )
      })
    })

    observeEvent(input$appendItem, {
      updateF7VirtualList(
        id = "vlist",
        action = "appendItem",
        item = f7VirtualListItem(
          title = "New Item Title",
          right = "New Item Right",
          "New Item Content",
          media = img(src = "https://cdn.framework7.io/placeholder/fashion-88x88-3.jpg")
        )
      )
    })

    observeEvent(input$prependItems, {
      updateF7VirtualList(
        id = "vlist",
        action = "prependItems",
        items = lapply(1:5, function(i) {
          f7VirtualListItem(
            title = paste("Title", i),
            right = paste("Right", i),
            i,
            media = img(src = "https://cdn.framework7.io/placeholder/fashion-88x88-3.jpg")
          )
        })
      )
    })

    observeEvent(input$insertBefore, {
      updateF7VirtualList(
        id = "vlist",
        action = "insertItemBefore",
        index = input$itemIndex,
        item = f7VirtualListItem(
          title = "New Item Title",
          "New Item Content",
          media = img(src = "https://cdn.framework7.io/placeholder/fashion-88x88-3.jpg")
        )
      )
    })

    observeEvent(input$replaceItem, {
      updateF7VirtualList(
        id = "vlist",
        action = "replaceItem",
        index = input$itemIndex,
        item = f7VirtualListItem(
          title = "Replacement",
          "Replacement Content",
          media = img(src = "https://cdn.framework7.io/placeholder/fashion-88x88-3.jpg")
        )
      )
    })

    observeEvent(input$deleteAllItems, {
      updateF7VirtualList(
        id = "vlist",
        action = "deleteAllItems"
      )
    })

    observeEvent(input$moveItem, {
      updateF7VirtualList(
        id = "vlist",
        action = "moveItem",
        oldIndex = input$itemIndex,
        newIndex = input$itemNewIndex
      )
    })

    observeEvent(input$filterItems, {
      updateF7VirtualList(
        id = "vlist",
        action = "filterItems",
        indexes = input$itemsFilter[1]:input$itemsFilter[2]
      )
    })

  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
