% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-checkboxgroupbuttons.R
\name{updateCheckboxGroupButtons}
\alias{updateCheckboxGroupButtons}
\title{Change the value of a checkboxes group buttons input on the client}
\usage{
updateCheckboxGroupButtons(session, inputId, selected = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{selected}{The values selected.}
}
\description{
Change the value of a radio group buttons input on the client
}
\examples{
\dontrun{
if (interactive()) {

library(shiny)
library(shinyWidgets)


ui <- fluidPage(

  radioButtons(inputId = "up", label = "Update button :", choices = c("All", "None")),

  checkboxGroupButtons(
    inputId = "btn", label = "Power :",
    choices = c("Nuclear", "Hydro", "Solar", "Wind"),
    selected = "Hydro"
  ),

  verbatimTextOutput(outputId = "res")

)

server <- function(input,output, session){

  observeEvent(input$up, {
    if (input$up == "All"){
      updateCheckboxGroupButtons(session, "btn", selected = c("Nuclear", "Hydro", "Solar", "Wind"))
    } else {
      updateCheckboxGroupButtons(session, "btn", selected = character(0))
    }
  }, ignoreInit = TRUE)

  output$res <- renderPrint({
    input$btn
  })
}

shinyApp(ui = ui, server = server)

}
}
}
