% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-airDatepicker.R
\name{airDatepicker}
\alias{airDatepicker}
\alias{airDatepickerInput}
\alias{timepickerOptions}
\alias{airMonthpickerInput}
\alias{airYearpickerInput}
\title{Air Date Picker Input}
\usage{
airDatepickerInput(
  inputId,
  label = NULL,
  value = NULL,
  multiple = FALSE,
  range = FALSE,
  timepicker = FALSE,
  separator = " - ",
  placeholder = NULL,
  dateFormat = "yyyy-mm-dd",
  minDate = NULL,
  maxDate = NULL,
  disabledDates = NULL,
  view = c("days", "months", "years"),
  minView = c("days", "months", "years"),
  monthsField = c("monthsShort", "months"),
  clearButton = FALSE,
  todayButton = FALSE,
  autoClose = FALSE,
  timepickerOpts = timepickerOptions(),
  position = NULL,
  update_on = c("change", "close"),
  addon = c("right", "left", "none"),
  language = "en",
  inline = FALSE,
  width = NULL
)

timepickerOptions(
  dateTimeSeparator = NULL,
  timeFormat = NULL,
  minHours = NULL,
  maxHours = NULL,
  minMinutes = NULL,
  maxMinutes = NULL,
  hoursStep = NULL,
  minutesStep = NULL
)

airMonthpickerInput(inputId, label = NULL, value = NULL, ...)

airYearpickerInput(inputId, label = NULL, value = NULL, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value(s), dates as character string are accepted in \code{yyyy-mm-dd} format,
or Date/POSIXct object. Can be a single value or several values.}

\item{multiple}{Select multiple dates.}

\item{range}{Select a date range.}

\item{timepicker}{Add a timepicker below calendar to select time.}

\item{separator}{Separator between dates when several are selected, default to \code{" - "}.}

\item{placeholder}{A character string giving the user a hint as to what can be entered into the control.}

\item{dateFormat}{Format to use to display date(s), default to \code{"yyyy-mm-dd"}}

\item{minDate}{The minimum allowed date. Either a Date object, or a string in \code{yyyy-mm-dd} format.}

\item{maxDate}{The maximum allowed date. Either a Date object, or a string in \code{yyyy-mm-dd} format.}

\item{disabledDates}{A vector of dates to disable, e.g. won't be able to select one of dates passed.}

\item{view}{Starting view, one of \code{'days'} (default), \code{'months'} or \code{'years'}.}

\item{minView}{Minimal view, one of \code{'days'} (default), \code{'months'} or \code{'years'}.}

\item{monthsField}{Names for the months when view is 'months',
use \code{'monthsShort'} for abbreviations or \code{'months'} for full names.}

\item{clearButton}{If \code{TRUE}, then button "Clear" will be visible.}

\item{todayButton}{If \code{TRUE}, then button "Today" will be visible.}

\item{autoClose}{If \code{TRUE}, then after date selection, datepicker will be closed.}

\item{timepickerOpts}{Options for timepicker, see \link{timepickerOptions}.}

\item{position}{Where calendar should appear, a two word string like
\code{'bottom left'} (default), or \code{'top right'}, \code{'left top'}.}

\item{update_on}{When to send selected value to server: on \code{'change'}
or when calendar is \code{'close'}d.}

\item{addon}{Display a calendar icon to \code{'right'} or the \code{'left'}
of the widget, or \code{'none'}. This icon act likes an \code{actionButton},
you can retrieve value server-side with \code{input$<inputId>_button}.}

\item{language}{Language to use, can be one of \code{'cs'}, \code{'da'},
\code{'de'}, \code{'en'}, \code{'es'}, \code{'fi'}, \code{'fr'},
\code{'hu'}, \code{'nl'}, \code{'pl'}, \code{'pt-BR'}, \\code{'pt'},
\code{'ro'}, \code{'ru'}, \code{'sk'}, \code{'zh'}.}

\item{inline}{If \code{TRUE}, datepicker will always be visible.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'}.}

\item{dateTimeSeparator}{Separator between date and time, default to \code{" "}.}

\item{timeFormat}{Desirable time format. You can use \code{h} (hours), \code{hh}
(hours with leading zero), \code{i} (minutes), \code{ii} (minutes with leading zero),
\code{aa} (day period - 'am' or 'pm'), \code{AA} (day period capitalized)}

\item{minHours}{Minimal hours value, must be between 0 and 23. You will not be able to choose value lower than this.}

\item{maxHours}{Maximum hours value, must be between 0 and 23. You will not be able to choose value higher than this.}

\item{minMinutes}{Minimal minutes value, must be between 0 and 59. You will not be able to choose value lower than this.}

\item{maxMinutes}{Maximum minutes value, must be between 0 and 59. You will not be able to choose value higher than this.}

\item{hoursStep}{Hours step in slider.}

\item{minutesStep}{Minutes step in slider.}

\item{...}{Arguments passed to \code{airDatepickerInput}.}
}
\value{
a \code{Date} object or a \code{POSIXct} in UTC timezone.
}
\description{
An alternative to \code{dateInput} to select single, multiple or date range.
 And two alias to select months or years.
}
\note{
This widget prevents \code{dateInput} from working, don't use both !
}
\examples{
if (interactive()) {

# examples of different options to select dates:
demoAirDatepicker("datepicker")

# select month(s)
demoAirDatepicker("months")

# select year(s)
demoAirDatepicker("years")

# select date and time
demoAirDatepicker("timepicker")

# You can select multiple dates :
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  airDatepickerInput(
    inputId = "multiple",
    label = "Select multiple dates:",
    placeholder = "You can pick 5 dates",
    multiple = 5, clearButton = TRUE
  ),
  verbatimTextOutput("res")
)

server <- function(input, output, session) {
  output$res <- renderPrint(input$multiple)
}

shinyApp(ui, server)

}
}
\seealso{
See \code{\link{updateAirDateInput}} for updating slider value server-side.
 And \code{\link{demoAirDatepicker}} for examples.
}
