% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WinBox.R
\name{WinBox}
\alias{WinBox}
\alias{closeWinBox}
\title{WinBox}
\usage{
WinBox(
  title,
  ui,
  options = wbOptions(),
  controls = wbControls(),
  id = NULL,
  padding = "5px 10px",
  auto_height = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

closeWinBox(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{title}{Title for the window.}

\item{ui}{Content of the window.}

\item{options}{List of options, see \code{\link[=wbOptions]{wbOptions()}}.}

\item{controls}{List of controls, see \code{\link[=wbControls]{wbControls()}}.}

\item{id}{An unique identifier for the window, if a window with the same \code{id} is already open,
it will be closed before opening the new one. When closing windows, use \code{id = NULL} to close last one opened.}

\item{padding}{Padding for the window content.}

\item{auto_height}{Automatically set height of the window according to content.
Note that if content does not have a fix height it may not work properly.}

\item{session}{Shiny session.}
}
\value{
No value, a window is openned in the UI.
}
\description{
A window manager with JavaScript library \href{https://nextapps-de.github.io/winbox/}{WinBox.js}.
}
\note{
You need to include \code{\link[=html_dependency_winbox]{html_dependency_winbox()}} in your UI definition for this function to work.
}
\examples{

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  html_dependency_winbox(),
  actionButton(inputId = "show", label = "Show WinBox"),
  verbatimTextOutput("res")
)

server <- function(input, output, session) {

  observeEvent(input$show, {
    WinBox(
      title = "WinBox window",
      ui = tagList(
        tags$h2("Hello from WinBox!"),
        "Text content of winbox.",
        selectInput("month", "Select a month:", month.name)
      )
    )
  })

  output$res <- renderPrint(input$month)

}

if (interactive())
  shinyApp(ui, server)
}
