% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-time.R
\name{time-input}
\alias{time-input}
\alias{timeInput}
\alias{updateTimeInput}
\title{Time input}
\usage{
timeInput(
  inputId,
  label,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL,
  width = NULL
)

updateTimeInput(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value, foramtted as \code{"HH:MM"} or \code{"HH:MM:SS"}.}

\item{min, max}{Minimal and maximal value, use same format as in \code{value}.}

\item{step}{It takes an integer value that equates to the number of seconds you want to increment by;
the default value is 60 seconds, or one minute. If you specify a value of less than 60 seconds (1 minute),
the time input will show a seconds input area alongside the hours and minutes.
This property has some strange effects across browsers, so is not completely reliable.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}

\item{session}{Default Shiny session.}
}
\value{
A time input control that can be added to a UI definition.
}
\description{
This widget allow to select hour and minute using the default browser time input.
See \href{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/time}{developer.mozilla.org} for more.
}
\examples{

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Time Input"),
  fluidRow(
    column(
      width = 6,
      timeInput(
        inputId = "time1",
        label = "Time:"
      ),
      verbatimTextOutput("res1"),
      timeInput(
        inputId = "time2",
        label = "Time (default value):",
        value = "09:30"
      ),
      verbatimTextOutput("res2"),
      timeInput(
        inputId = "time3",
        label = "Time (with seconds):",
        step = 1
      ),
      verbatimTextOutput("res3")
    ),
    column(
      width = 6,
      timeInput(inputId = "time4", label = "Time:"),
      verbatimTextOutput("res4"),
      numericInput("up_h", "Update hour;", value = 0),
      numericInput("up_m", "Update minute;", value = 0)
    )
  )
)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$time1)
  output$res2 <- renderPrint(input$time2)
  output$res3 <- renderPrint(input$time3)
  output$res4 <- renderPrint(input$time4)

  observe({
    updateTimeInput(
      inputId = "time4",
      value = paste(
        # Hour and minute need to be a field of minimum width 2,
        # with zero-padding on the left
        sprintf("\%02d", input$up_h),
        sprintf("\%02d", input$up_m),
        sep = ":"
      )
    )
  })
}

if (interactive())
  shinyApp(ui, server)
}
