% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R
\name{renderUser}
\alias{renderUser}
\title{Create dynamic user output (server side)}
\usage{
renderUser(expr, env = parent.frame(), quoted = FALSE, outputArgs = list())
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link[shiny:HTML]{HTML()}},
or a list of such objects.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[shiny:uiOutput]{uiOutput()}} when \code{renderUI} is used in an
interactive R Markdown document.}
}
\description{
Create dynamic user output (server side)
}
\seealso{
\code{\link{userOutput}} for the corresponding client side function
  and examples.

Other user outputs: 
\code{\link{userOutput}()}
}
\concept{user outputs}
