% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullscreen_this.R
\name{fullscreen_this}
\alias{fullscreen_this}
\title{Enable fullscreen for a specific item}
\usage{
fullscreen_this(ui_element, click_id = NULL, bg_color = "#fff")
}
\arguments{
\item{ui_element}{A UI element that should be displayed fullscreen.}

\item{click_id}{Id of the item that triggers the fullscreen view. By default, it is the id of \code{ui_element}, i.e clicking on the element shows it on fullscreen. You can specify the id of a button for instance, so that clicking on this button triggers the fullscreen view of \code{ui_element}.}

\item{bg_color}{Background color when item is displayed fullscreen. Default is white.}
}
\value{
Enables the selected element to be displayed in fullscreen mode.
}
\description{
Enable fullscreen for a specific item
}
\examples{
if (interactive()) {
### Only works in browser

library(shiny)

ui <- fluidPage(
  actionButton("test", "test"),
  fullscreen_this(plotOutput("plot"))
)

server <- function(input, output, session) {

  output$plot <- renderPlot(plot(mtcars))

}

shinyApp(ui, server, options = list(launch.browser = TRUE))
}
}
