% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_credentials.R
\name{check_credentials}
\alias{check_credentials}
\title{Check credentials}
\usage{
check_credentials(db, passphrase = NULL)
}
\arguments{
\item{db}{A \code{data.frame} with credentials data or path to SQLite database created with \code{\link{create_db}}.}

\item{passphrase}{Passphrase to decrypt the SQLite database.}
}
\value{
Return a \code{function} with two arguments: \code{user} and \code{password}
to be used in \code{\link{module-authentication}}. The authentication function returns
a \code{list} with 3 slots :
 \itemize{
  \item \strong{result} : logical, result of authentication.
  \item \strong{expired} : logical, is user has expired ? Always \code{FALSE} if \code{db} doesn't have a \code{expire} column.
  \item \strong{user_info} : the line in \code{db} corresponding to the user.
 }
}
\description{
Check credentials
}
\details{
The credentials \code{data.frame} can have the following columns:
 \itemize{
  \item \strong{user (mandatory)} : the user's name.
  \item \strong{password (mandatory)} : the user's password.
  \item \strong{admin (optional)} : logical, is user have admin right ? If so,
   user can access the admin mode (only available using a SQLite database)
  \item \strong{start (optional)} : the date from which the user will have access to the application
  \item \strong{expire (optional)} : the date from which the user will no longer have access to the application
  \item \strong{applications (optional)} : the name of the applications to which the user is authorized,
   separated by a semicolon. The name of the application corresponds to the name of the directory,
   or can be declared using : \code{options("shinymanager.application" = "my-app")}
  \item \strong{additional columns} : add others columns to retrieve the values server-side after authentication
 }
}
\examples{
# data.frame with credentials info
credentials <- data.frame(
  user = c("fanny", "victor"),
  password = c("azerty", "12345"),
  stringsAsFactors = FALSE
)

# check a user
check_credentials(credentials)("fanny", "azerty")
check_credentials(credentials)("fanny", "azert")
check_credentials(credentials)("fannyyy", "azerty")

\dontrun{

## With a SQLite database:

check_credentials("credentials.sqlite", passphrase = "supersecret")

}

}
