% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-switch.R
\name{material_switch}
\alias{material_switch}
\title{Create a shinymaterial switch}
\usage{
material_switch(input_id, label, off_label = "", on_label = "",
  initial_value = FALSE, color = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The switch label.}

\item{off_label}{String. The label for the 'off' position of the switch.}

\item{on_label}{String. The label for the 'on' position of the switch.}

\item{initial_value}{Boolean. Is the switch initially on?}

\item{color}{String. The color of the switch. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors. \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}
}
\description{
Build a shinymaterial switch. The value is a boolean (TRUE if 'on', FALSE if 'off').
}
\examples{
material_switch(
  input_id = "example_switch",
  label = "Switch",
  off_label = "Off",
  on_label = "On",
  initial_value = TRUE,
  color = "#ef5350"
)
}
\seealso{
\code{\link{update_material_switch}}
}
