% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shinystan-package.R
\docType{package}
\name{shinystan-package}
\alias{shinystan-package}
\title{The ShinyStan interface and shinystan R package}
\description{
Applied Bayesian data analysis is primarily implemented through
  the MCMC algorithms offered by various software packages. When analyzing a
  posterior sample obtained by one of these algorithms the first step is to
  check for signs that the chains have converged to the target distribution
  and and also for signs that the algorithm might require tuning or might be
  ill-suited for the given model. There may also be theoretical problems or
  practical inefficiencies with the specification of the model. ShinyStan
  provides interactive plots and tables helpful for analyzing a posterior
  sample, with particular attention to identifying potential problems with
  the performance of the MCMC algorithm or the specification of the model.
  ShinyStan is powered by RStudio's Shiny web application framework and works
  with the output of MCMC programs written in any programming language (and
  has extended functionality for models fit using the rstan package and the
  No-U-Turn sampler).
}
\section{ShinyStan has extended functionality for Stan models}{


  Stan (\url{http://mc-stan.org}) models can be run in R using the
  \pkg{rstan} package.
}

\section{Saving and sharing}{


  The shinystan package allows you to store the basic components of an entire
  project (code, posterior samples, graphs, tables, notes) in a single
  object. Users can save many of the plots as ggplot2 objects for further
  customization and easy integration in reports or post-processing for
  publication.

  The new version of shinystan also provides the `deploy_shinystan` function,
  which lets you easily deploy your own ShinyStan apps online using RStudio's
  ShinyApps (\url{https://www.shinyapps.io}) service for any of your models.
  Each of your apps (each of your models) will have a unique url and is
  compatible with Safari, Firefox, Chrome, and most other browsers.
}

\section{License}{


 The shinystan package is open source licensed under the GNU Public License,
 version 3 (GPLv3).
}

\section{Demo}{


 Check out the demo using \code{\link{launch_shinystan_demo}} or try it with
 one of your own models using \code{\link{launch_shinystan}}.
}

