% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{sv_between}
\alias{sv_between}
\title{Validate that a field is a number bounded by minimum and maximum values}
\usage{
sv_between(
  left,
  right,
  inclusive = c(TRUE, TRUE),
  message_fmt = "Must be between {left} and {right}.",
  allow_na = FALSE,
  allow_nan = FALSE
)
}
\arguments{
\item{left, right}{The left and right boundary values. Inclusively for each of
the boundaries is set with the \code{inclusive} argument; the defaults are set
for inclusive bounds.}

\item{inclusive}{A two-element logical vector that indicates whether the
\code{left} and \code{right} bounds, respectively, should be inclusive. Both bounds
are by default are inclusive, using \code{c(TRUE, TRUE)}.}

\item{message_fmt}{The validation error message to use if a value fails to
match the rule. The message can be customized by using the \code{"{left}"} and
\code{"{right}"} string parameters, which allows for the insertion of the \code{left}
and \code{right} values. While the default message uses both of these string
parameters, they are not required in a user-defined \code{message_fmt} string.}

\item{allow_na}{If \code{FALSE} (the default for both options), then any
\code{NA} or \code{NaN} element will cause validation to fail.}

\item{allow_nan}{If \code{FALSE} (the default for both options), then any
\code{NA} or \code{NaN} element will cause validation to fail.}
}
\value{
A function suitable for use as an
\code{\link[=InputValidator]{InputValidator$add_rule()}} rule.
}
\description{
The \code{sv_between()} function validates that a field has values between left
and right boundary values. Both bounds are inclusive by default, but both can
be set as either inclusive or exclusive with the \code{inclusive} argument. In its
default mode, the validation check will effectively be of the form \verb{<left> <= <field> <= <right>}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyvalidate)

ui <- fluidPage(
  textInput("count", "Count")
)

server <- function(input, output, session) {
  
  # Validation rules are set in the server, start by
  # making a new instance of an `InputValidator()`
  iv <- InputValidator$new()

  # Basic usage: `sv_between()` requires `left` and
  # `right` boundary values; a message will be
  # displayed if the validation of `input$count` fails
  iv$add_rule("count", sv_between(10, 100))

  # Finally, `enable()` the validation rules
  iv$enable()
}

shinyApp(ui, server)

}

}
\seealso{
The \code{\link[=sv_in_set]{sv_in_set()}} function, which tests whether a field values are
part of a specified set.

Other rule functions: 
\code{\link{compose_rules}()},
\code{\link{sv_email}()},
\code{\link{sv_equal}()},
\code{\link{sv_gte}()},
\code{\link{sv_gt}()},
\code{\link{sv_in_set}()},
\code{\link{sv_integer}()},
\code{\link{sv_lte}()},
\code{\link{sv_lt}()},
\code{\link{sv_not_equal}()},
\code{\link{sv_numeric}()},
\code{\link{sv_optional}()},
\code{\link{sv_regex}()},
\code{\link{sv_required}()},
\code{\link{sv_url}()}
}
\concept{rule functions}
