% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorts_S3.R
\name{plot.shorts_model}
\alias{plot.shorts_model}
\title{S3 method for plotting \code{shorts_model} object}
\usage{
\method{plot}{shorts_model}(x, type = NULL, ...)
}
\arguments{
\item{x}{\code{shorts_model} object}

\item{type}{Not used}

\item{...}{Not used}
}
\value{
\link[ggplot2]{ggplot} object
}
\description{
S3 method for plotting \code{shorts_model} object
}
\examples{
split_times <- data.frame(
  distance = c(5, 10, 20, 30, 35),
  time = c(1.20, 1.96, 3.36, 4.71, 5.35)
)

# Simple model with time splits
simple_model <- with(
  split_times,
  model_using_splits(distance, time)
)

coef(simple_model)
plot(simple_model)

# Simple model with radar gun data
instant_velocity <- data.frame(
  time = c(0, 1, 2, 3, 4, 5, 6),
  velocity = c(0.00, 4.99, 6.43, 6.84, 6.95, 6.99, 7.00)
)

radar_model <- with(
  instant_velocity,
  model_using_radar(time, velocity)
)

# sprint_model$parameters
coef(radar_model)
plot(radar_model)
}
