% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-FV.R
\name{convert_FV}
\alias{convert_FV}
\title{Convert Force-Velocity profile back to Acceleration-Velocity profile}
\usage{
convert_FV(F0, V0, bodymass = 75, inertia = 0, resistance = 0, ...)
}
\arguments{
\item{F0, V0}{Numeric vectors. FV profile parameters}

\item{bodymass}{Body mass in kg. Used to calculate relative power and forwarded to \code{\link{get_air_resistance}}}

\item{inertia}{External inertia in kg (for example a weight vest, or a sled).
Not included in the air resistance calculation}

\item{resistance}{External horizontal resistance in Newtons (for example tether device or a sled friction resistance)}

\item{...}{Forwarded to \code{\link{get_air_resistance}} for the purpose of calculation of air resistance and power}
}
\value{
A list with calculated \code{MSS} and \code{MAC} parameters
}
\description{
This function converts back the Force-Velocity (FV) profile to Acceleration-Velocity (AP)
    profile
}
\examples{
FVP <- make_FV_profile(7, 8.3, inertia = 10, resistance = 50)

convert_FV(FVP$F0, FVP$V0, inertia = 10, resistance = 50)
}
