% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_shrink_TVP_res.R
\name{plot.mcmc.tvp}
\alias{plot.mcmc.tvp}
\title{Graphical summary of posterior distribution for a time-varying parameter}
\usage{
\method{plot}{mcmc.tvp}(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975), ...)
}
\arguments{
\item{x}{a mcmc.tvp object}

\item{probs}{numeric vector of quantiles to plot for each point in time, with values in [0,1].
The value 0.5 is added to \code{probs} if the user does not include it.
The default value is \code{c(0.025, 0.25, 0.5, 0.75, 0.975)}.}

\item{...}{further arguments to be passed to \code{plot}.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{plot.mcmc.tvp} plots empirical posterior quantiles for a time-varying parameter.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

output <- shrinkTVP(y ~ x1 + x2, data)
plot(output$beta$beta_x1)
}
}
