% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{categorize}
\alias{categorize}
\title{Categorize input data by comparing the AIC values of the three fitted models.}
\usage{
categorize(parameterVectorLinear, parameterVectorSigmoidal,
  parameterVectorDoubleSigmoidal, threshold_line_slope_parameter = 0.01,
  threshold_intensity_interval = 0.1,
  threshold_minimum_for_intensity_maximum = 0.3,
  threshold_difference_AIC = 0,
  threshold_lysis_finalAsymptoteIntensity = 0.75, threshold_AIC = -10)
}
\arguments{
\item{parameterVectorLinear}{output from lineFitFunction.}

\item{parameterVectorSigmoidal}{output from sigmoidalFitFunction.}

\item{parameterVectorDoubleSigmoidal}{output from doublesigmoidalFitFunction.}

\item{threshold_line_slope_parameter}{minimum for line slope (Default is 0.01).}

\item{threshold_intensity_interval}{minimum for intensity range (Default is 0.1).}

\item{threshold_minimum_for_intensity_maximum}{minimum allowed value for intensity maximum}

\item{threshold_difference_AIC}{choice between sigmoidal and double sigmoidal by using AIC values (Default is 0).}

\item{threshold_lysis_finalAsymptoteIntensity}{minimum amount of decrease for double sigmoidal (Default is 0.75).}

\item{threshold_AIC}{maximum AIC values in order to have a meaningful fit (Default is -10).}
}
\value{
Function returns one of the three text outputs, "no_signal", "infection", or "infection&lysis".
}
\description{
Catagorizes dat using the results of all three fitted models (linear, sigmoidal, and double sigmoidal).
}
\examples{
# Example 1 with double sigmoidal data
time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.2
intensity_noise=runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=doublesigmoidalFitFormula(time,
                                   finalAsymptoteIntensity=.3,
                                   maximum=4,
                                   slope1=1,
                                   midPoint1=7,
                                   slope2=1,
                                   midPointDistance=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput,dataInputName="batch_01_21_2016_samp007623")


# Fit linear model
linearModel=fitFunction(dataInput=normalizedInput,
                                 model="linear",
                                 n_runs_min=20,
                                 n_runs_max=500,
                                 showDetails=FALSE)

# Fit sigmoidal model
sigmoidalModel=fitFunction(dataInput=normalizedInput,
                                    model="sigmoidal",
                                    n_runs_min=20,
                                    n_runs_max=500,
                                    showDetails=FALSE)

# Fit double sigmoidal model
doubleSigmoidalModel=fitFunction(dataInput=normalizedInput,
                                          model="doublesigmoidal",
                                          n_runs_min=20,
                                          n_runs_max=500,
                                          showDetails=FALSE)


outputCluster=categorize(parameterVectorLinear=linearModel,
                        parameterVectorSigmoidal=sigmoidalModel,
                        parameterVectorDoubleSigmoidal=doubleSigmoidalModel)



}

