% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_features}
\alias{get_features}
\title{Derive copy number feature distributions}
\usage{
get_features(CN_data, cores = 1, genome_build = c("hg19", "hg38"))
}
\arguments{
\item{CN_data}{a \code{list} contains multiple \code{data.frame}s (recommended),
each \code{data.frame} stores copy-number profile for one sample with 'chromosome', 'start', 'end' and
'segVal' these four necessary columns. Of note, 'segVal' column shoule be absolute copy number values.}

\item{cores}{number of compute cores to run this task.
You can use \code{\link[parallel:detectCores]{parallel::detectCores()}} function to check how
many cores you can use.}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}
}
\value{
a \code{list} contains six copy number feature distributions.
}
\description{
This function summarise each copy-number profile using a number of different
feature distributions: sigment size, breakpoint number (per ten megabase), change-point copy-number,
segment copy-number, breakpoint number (per chromosome arm), length of segments with oscilating
copy-number.
}
\examples{
# Load copy number list
load(system.file("extdata", "toy_cnlist.RData",
  package = "sigminer", mustWork = TRUE
))
\donttest{
cn_features <- get_features(cn_list, cores = 1)
}
}
\seealso{
Other internal calculation function series: \code{\link{get_ArmLocation}},
  \code{\link{get_LengthFraction}},
  \code{\link{get_cnlist}},
  \code{\link{get_cnsummary_sample}},
  \code{\link{get_components}}, \code{\link{get_matrix}}
}
\author{
Geoffrey Macintyre, Shixiang Wang
}
\concept{internal calculation function series}
