% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_prepare}
\alias{sig_prepare}
\alias{sig_prepare.CopyNumber}
\alias{sig_prepare.MAF}
\alias{sig_prepare.GenomicVariation}
\title{Prepare variation signature analysis}
\usage{
sig_prepare(object, ...)

\method{sig_prepare}{CopyNumber}(object, reference_components = FALSE,
  cores = 1, seed = 123456, min_comp = 2, max_comp = 10,
  min_prior = 0.001, model_selection = "BIC", nrep = 1,
  niter = 1000, rowIter = 1000, ...)

\method{sig_prepare}{MAF}(object, ref_genome = NULL, prefix = NULL,
  add = TRUE, ignoreChr = NULL, useSyn = TRUE, ...)

\method{sig_prepare}{GenomicVariation}(object, ...)
}
\arguments{
\item{object}{a \link{CopyNumber} object or \link{MAF} object or
\link{GenomicVariation} (not support for now) object.}

\item{...}{custom setting for operating object. Detail see S3 method for
corresponding class (e.g. \code{CopyNumber}).}

\item{reference_components}{default is \code{FALSE}, calculate mixture components
from \link{CopyNumber} object.
If set it to \code{NULL}, use pre-compiled components data which come from
\href{https://www.nature.com/articles/s41588-018-0179-8}{CNV signature paper}.
If can also be a \code{list} contain flexmix object of copy-number features,
obtain this from \link{get_components} function.}

\item{cores}{number of compute cores to run this task.
You can use \code{\link[parallel:detectCores]{parallel::detectCores()}} function to check how
many cores you can use.}

\item{seed}{seed number.}

\item{min_comp}{minimal number of components to fit, default is 2.
Can also be a vector with length 6, which apply to each feature.}

\item{max_comp}{maximal number of components to fit, default is 10.
Can also be a vector with length 6, which apply to each feature.}

\item{min_prior}{minimal prior value, default is 0.001.
Details about custom setting please refer to \strong{flexmix} package.}

\item{model_selection}{model selection strategy, default is 'BIC'.
Details about custom setting please refer to \strong{flexmix} package.}

\item{nrep}{number of run times for each value of component,
keep only the solution with maximum likelihood.}

\item{niter}{maximal number of iteration to achive converge.}

\item{rowIter}{step size of iteration for rows of ech CNV feature.}

\item{ref_genome}{BSgenome object or name of the installed BSgenome package. Example: BSgenome.Hsapiens.UCSC.hg19
Default NULL, tries to auto-detect from installed genomes.}

\item{prefix}{Prefix to add or remove from contig names in MAF file.}

\item{add}{If prefix is used, default is to add prefix to contig names in MAF file. If false prefix will be removed from contig names.}

\item{ignoreChr}{Chromsomes to ignore from analysis. e.g. chrM}

\item{useSyn}{Logical. Whether to include synonymous variants in analysis. Defaults to TRUE}
}
\value{
a \code{list} contains a \code{matrix} used for NMF de-composition.
}
\description{
Generate a matrix for NMF de-composition.
}
\details{
The result matrix generated further need to transpose before calling NMF
if user use \link[NMF:nmf]{NMF::nmf} by hand.
}
\section{Methods (by class)}{
\itemize{
\item \code{CopyNumber}: Signature analysis prepare for CopyNumber object

\item \code{MAF}: Signature analysis prepare for CopyNumber object

\item \code{GenomicVariation}: Signature analysis prepare for GenomicVariation object
}}

\examples{
\donttest{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
# Prepare copy number signature analysis
cn_prepare <- sig_prepare(cn)
}
}
\references{
Mayakonda, Anand, et al. "Maftools: efficient and comprehensive analysis of somatic variants in cancer." Genome research 28.11 (2018): 1747-1756.
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_estimate}}, \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_summarize_subtypes}}
}
\author{
Shixiang Wang
}
\concept{signature analysis series function}
