% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bayesian_result.R
\name{get_bayesian_result}
\alias{get_bayesian_result}
\title{Get Specified Bayesian NMF Result from Run}
\usage{
get_bayesian_result(run_info)
}
\arguments{
\item{run_info}{a \code{data.frame} with 1 row and two necessary columns \code{Run} and \code{file}.}
}
\value{
a \code{list}.
}
\description{
Sometimes, we may want to use or inspect specified run result from \link{sig_auto_extract}.
This function is designed for this purpose.
}
\examples{
load(system.file("extdata", "toy_copynumber_tally_W.RData",
  package = "sigminer", mustWork = TRUE
))

res <- sig_auto_extract(cn_tally_W$nmf_matrix, result_prefix = "Test_copynumber", nrun = 1)

# All run info are stored in res$Raw$summary_run
# Obtain result of run 1
res_run1 <- get_bayesian_result(res$Raw$summary_run[1, ])
}
\author{
Shixiang Wang
}
